/**
 * 服务层 - 数据交互
 */
angular.module("app.system")
.factory('Config', function () {
	return {
		// 每页显示记录数
		pageSize: 50,
		// 列表页可更换的每页记录数
		numPerPageOptions: [3, 5, 10, 20,50]
	};
})
.factory('Common', ["$uibModal", function ($uibModal) {
	return {
		// 打开窗口
		dialog: function (templateUrl, controllerName, data) {
			data = data ? data : '';

			$uibModal.open({
				animation:   true,
				templateUrl: templateUrl,
				controller:  controllerName,
				resolve: {
					items: function () {
						return data;
					}
				}
			});
		},
		// 消息窗口
		message: function (msg) {
			$uibModal.open({
				animation:   true,
				templateUrl: 'modalMessage.html',
				controller:  'ModalMessageCtrl',
				resolve: {
					items: function () {
						return msg;
					}
				}
			});
		}
	};
}])
.factory('Role', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords: keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		//权限管理
		permission:function(data, success_callback, error_callback){
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().permission({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/role/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				permission: {
					method: 'PUT',
					url: '/admin/role/permission/:id'
				},
				status: {
					method: 'PUT',
					url: '/admin/role/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})
.factory('Members', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords: keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/member/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/member/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Projects', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, name: keywords['project_name'], status: keywords['status'], appo_status: keywords['appo_status']};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/project/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/project/status/:id'
				},
				appointment:{
					method: 'GET',
					url: '/admin/appointment/:id'
				},
				finish:{
					method: 'PUT',
					url: '/admin/project/finish/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Categorys', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/category/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/category/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Articles', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/article/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/article/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Ads', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/ad/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/ad/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Users', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/user/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/user/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Brands', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/brand/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/brand/status/:id'
				}
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})
.factory('Template', function($resource) {
    var datas = {}, params = {};

    return {
        // 列表数据
        getList: function (page, pageSize, keywords) {
            keywords = keywords ? keywords : '';
            var _self = this;

			var param = {page: page, pagesize: pageSize, name: keywords['name'], brand_name: keywords['brand_name']};

            _self.setParams(param);

            var resource = _self.resource();

            return resource.query(params, function (json) {
                json.currentPage = page;

                _self.setDatas(json);
            }, function (err) {
                console.log(err);
            });
        },
        // 添加、编辑处理
        doEdit: function (data, success_callback, error_callback) {
            var _self = this;
            var id = data.id;
            delete data.id;

            // update
            if (id > 0) {
                _self.resource().update({id: id}, data, function (res) {
                    success_callback(res);
                }, function (err) {
                    error_callback(err);
                });
            }
            // add
            else {
                _self.resource().save(data, function (res) {
                    success_callback(res);
                }, function (err) {
                    error_callback(err);
                });
            }
        },
        // 返回resource资源对象
        resource: function () {
            return $resource('/admin/template/:id', { id: '@id' }, {
                query: {
                    method: 'GET',
                    isArray: false
                },
                update: {
                    method: 'PUT'
                },
                status: {
                    method: 'PUT',
                    url: '/admin/template/status/:id'
                },
                copy: {
                    method: 'PUT',
                    url: '/admin/template/copy/:id'
                }
            });
        },
        getDatas: function () {
            return datas;
        },
        setDatas: function (val) {
            datas = val;
        },
        getParams: function () {
            return params;
        },
        setParams: function (param) {
            params = param;
        }
    };
})

.factory('Enquirys', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/enquiry/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/enquiry/status/:id'
				},
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})
.factory('Signboards', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/enquiry/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/enquiry/status/:id'
				},
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})
.factory('Discounts', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/discount/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/discount/status/:id'
				},
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})
.factory('Services', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, keywords:keywords};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/service/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/services/statu/:id'
				},
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})

.factory('Bills', function($resource) {
	var datas = {}, params = {};

	return {
		// 列表数据
		getList: function (page, pageSize, keywords) {
			keywords = keywords ? keywords : '';
			var _self = this;

			var param = {page: page, pagesize: pageSize, prj_name: keywords['prj_name'], username: keywords['username']};
			_self.setParams(param);

			var resource = _self.resource();

			// query() ==> 获取所有数据: request '/admin/role/'
			return resource.query(params, function (json) {
				json.currentPage = page;

				_self.setDatas(json);
			}, function (err) {
				console.log(err);
			});
		},
		// 添加、编辑处理
		doEdit: function (data, success_callback, error_callback) {
			var _self = this;
			var id = data.id;
			delete data.id;

			// update
			if (id > 0) {
				_self.resource().update({id: id}, data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
			// add
			else {
				_self.resource().save(data, function (res) {
					success_callback(res);
				}, function (err) {
					error_callback(err);
				});
			}
		},
		// 返回resource资源对象
		resource: function () {
			return $resource('/admin/bill/:id', { id: '@id' }, {
				query: {
					method: 'GET',
					isArray: false
				},
				update: {
					method: 'PUT'
				},
				status: {
					method: 'PUT',
					url: '/admin/bill/statu/:id'
				},
			});
		},
		getDatas: function () {
			return datas;
		},
		setDatas: function (val) {
			datas = val;
		},
		getParams: function () {
			return params;
		},
		setParams: function (param) {
			params = param;
		}
	};
})
;