/**
 * 会员管理
 */
app_touchmedia
.controller("AdminUsersCtrl", ["$scope", "Common", "Config","Users", function ($scope, Common, Config,Users) {
    
    // 监控列表数据
    $scope.$watch(function () {
        return Users.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;
        $scope.roles = json.role;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
    });
    
    $scope.numPerPage = Config.pageSize;
    $scope.numPerPageOpt = Config.numPerPageOptions;
    $scope.currentPage = 1;

    Users.getList(1, Config.pageSize);

    // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Users.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Users.getList(currentPage, $scope.numPerPage);
    };
    
    //查询
    $scope.search = function () {
    	Users.getList(1, Config.pageSize, $scope.searchKeywords);
    };
    
    $scope.open = function(){
    	Common.dialog('modalAdd.html', 'ModalUsersAddCtrl',$scope.roles)
    };
    //刷新
    $scope.refresh = function(){
    	Users.getList(1, $scope.numPerPage);
    };
    
    // 禁用
    $scope.status = function (id, status, username) {
        Common.dialog('modalStatus.html', 'ModalRoleStatusCtrl', {id: id, status: status, username: username});
    };
    
    // 删除
    $scope.delete = function (id, name) {
        Common.dialog('modalDelete.html', 'ModalRoleDeleteCtrl', {id: id, name: name});
    };
    
    //编辑
    $scope.edit = function(id){
    	Users.resource().get({id: id}, function (data) {
              if (data.error == 0) {
                  Common.dialog('modalAdd.html', 'ModalUsersAddCtrl', data.data);
              }
          });
    }
}])
//添加、编辑
.controller('ModalUsersAddCtrl',["$scope","Common","items","Users", "$uibModalInstance",function($scope,Common,items,Users,$uibModalInstance){
	var currentId = items ? items.id : 0;
    // 账号启用状态
    $scope.roleStatus = items ? (items.status == 1 ? true : false) : true;
	$scope.email = items.email;
	$scope.email1 = items.email;
	$scope.name = items.name;
	$scope.role_id = items.role_id;
	if(typeof(currentId) == 'undefined')
	{
		$scope.roles = items;
		$scope.selected = items.role;
	}
	else //修改
	{
		$scope.roles = items.roles;
		$scope.selected = items.role_id;
	}
	
	$scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
    $scope.cancel = function () {
    	$uibModalInstance.dismiss("cancel");
    };
    
    $scope.ok = function () {
    	var data = {
            id : currentId,
            email : $scope.email,
            name : $scope.name,
            role_id : $scope.selected,
            password : $scope.password,
            rep_password : $scope.rep_password,
            status : !$scope.roleStatus ? 0 : 1
        };
    	
    	Users.doEdit(data, function (res) {
            if (res['error'] == 0) {
                var params = Users.getParams();
                Users.getList(params.page, params.pagesize, params.keywords);

                $uibModalInstance.dismiss("cancel");
                Common.message((currentId ? '修改' : '添加') + '成功.');
            } else {
                $scope.submitError = true;
                $scope.submit_errors = (currentId ? '修改' : '添加') + '失败,请刷新页面后重试.';
            }
        }, function (err) {
            $scope.submitError = true;

            var submit_errors = [];
            $.each(err.data, function (key, val) {
                submit_errors.push(val.join('<br />'));
            });
            $scope.submit_errors = submit_errors.join('<br />');
        });
    };
   
}])
//禁用操作
.controller('ModalRoleStatusCtrl',["$scope","$uibModalInstance","Common","items","Users",function($scope,$uibModalInstance, Common, items, Users){
	 var opName = (items.status == 0) ? '启用' : '禁用';
	    $scope.statusOp = opName;
	    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
	    $scope.userName = items.username;
	    
	    $scope.ok = function () {
	        var status = (items.status == 0) ? 1 : 0;
	        Users.resource().status({id: items.id}, {status: status}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Users.getParams();
	                Users.getList(params.page, params.pagesize, params.keywords);

	                msg = '已' + opName + '账号' + items.username + '.';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
	    };
	    $scope.cancel = function () {
	        $uibModalInstance.dismiss("cancel");
	    };
}])
// 删除操作
.controller("ModalRoleDeleteCtrl", ["$scope", "$uibModalInstance", "Members", "Common", "items", function ($scope, $uibModalInstance, Members, Common, items) {
    $scope.userName = items.username;

    $scope.ok = function () {
        Members.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Members.getParams();
                Members.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
;