/**
 * 会员管理
 */
app_touchmedia
.controller("AdminEnquirysCtrl", ["$scope", "Common", "Config","Enquirys", function ($scope, Common, Config,Enquirys,AdminAdsCtrl) {
	// 监控列表数据
    $scope.$watch(function () {
        return Enquirys.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
        
        $scope.numPerPage = Config.pageSize;
        $scope.numPerPageOpt = Config.numPerPageOptions;
        $scope.currentPage = 1;

    });
    Enquirys.getList(1, Config.pageSize);
    
    $scope.showDetail = function($event){
    		  	
    };
    
    
 // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Enquirys.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Enquirys.getList(currentPage, $scope.numPerPage);
    };
    
    
    //查询
    $scope.search = function () { 	
    	Enquirys.getList(1, Config.pageSize, $scope.searchKeywords);
    };
    
    
    // 禁用
    $scope.status = function (id, status) {
        Common.dialog('modalStatus.html', 'ModalAdStatusCtrl', {id: id, status: status});
    };
    
  //编辑
    $scope.edit = function(id){
    	Enquirys.resource().get({id: id}, function (data) {
            if (data.error == 0) {
                Common.dialog('modalAdd.html', 'ModalEnquirysAddCtrl', data.data);
            }
    	})
    }
}])
//添加、编辑
.controller('ModalEnquirysAddCtrl',["$scope","Common","items","Enquirys", "$uibModalInstance",function($scope,Common,items,Enquirys,$uibModalInstance){
	var currentId = items ? items.id : 0;
    // 账号启用状态
	$scope.name = items.first_name+' '+items.last_name;
	$scope.email = items.email;
	$scope.mobile = items.mobile;
	$scope.title = items.title;
	$scope.reply = items.reply;
	$scope.is_reply = items.is_reply;
	$scope.content = items.content;
	$scope.canSubmit = function () {
		if(items.is_reply == 1)
			return false;
        return $scope.form_admin_roles.$valid;
    };
    $scope.cancel = function () {
    	$uibModalInstance.dismiss("cancel");
    };
    
    $scope.ok = function () {
    	var data = {
            id : currentId,
            name : $scope.name,
            email : $scope.email,
            title : $scope.title,
            reply : $scope.reply,
        };
    	
    	Enquirys.doEdit(data, function (res) {
            if (res['error'] == 0) {
                var params = Enquirys.getParams();
                Enquirys.getList(params.page, params.pagesize, params.keywords);

                $uibModalInstance.dismiss("cancel");
                Common.message('回复成功.');
            } else {
                $scope.submitError = true;
                $scope.submit_errors = '回复失败,请刷新页面后重试.';
            }
        }, function (err) {
            $scope.submitError = true;

            var submit_errors = [];
            $.each(err.data, function (key, val) {
                submit_errors.push(val.join('<br />'));
            });
            $scope.submit_errors = submit_errors.join('<br />');
        });
    };
   
}])
//禁用操作
.controller('ModalAdStatusCtrl',["$scope","$uibModalInstance","Common","items","Ads",function($scope,$uibModalInstance, Common, items, Ads){
	 var opName = (items.status == 0) ? '启用' : '禁用';
	    $scope.statusOp = opName;
	    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
	    
	    $scope.ok = function () {
	        var status = (items.status == 0) ? 1 : 0;
	        Ads.resource().status({id: items.id}, {status: status}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Ads.getParams();
	                Ads.getList(params.page, params.pagesize, params.keywords);

	                msg = '已' + opName + '此广告.';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
	    };
	    $scope.cancel = function () {
	        $uibModalInstance.dismiss("cancel");
	    };
}])
// 删除操作
.controller("ModalRoleDeleteCtrl", ["$scope", "$uibModalInstance", "Members", "Common", "items", function ($scope, $uibModalInstance, Members, Common, items) {
    $scope.userName = items.username;

    $scope.ok = function () {
    	Articles.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Articles.getParams();
                Articles.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
;