/**
 * 会员管理
 */
app_touchmedia
.controller("AdminDiscrountsCtrl", ["$scope", "Common", "Config","Discounts", function ($scope, Common, Config,Discounts) {
    
    // 监控列表数据
    $scope.$watch(function () {
        return Discounts.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
    });
    
    $scope.numPerPage = Config.pageSize;
    $scope.numPerPageOpt = Config.numPerPageOptions;
    $scope.currentPage = 1;

    Discounts.getList(1, Config.pageSize);

    // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Discounts.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Discounts.getList(currentPage, $scope.numPerPage);
    };
    
    //查询
    $scope.search = function () {
    	Discounts.getList(1, Config.pageSize, $scope.searchKeywords);
    };
    
    $scope.open = function(){
    	Common.dialog('modalAdd.html', 'ModalDiscountsAddCtrl')
    };
    //刷新
    $scope.refresh = function(){
    	Discounts.getList(1, $scope.numPerPage);
    };
    
    // 禁用
    $scope.status = function (id, status, username) {
        Common.dialog('modalStatus.html', 'ModalRoleStatusCtrl', {id: id, status: status, username: username});
    };
    
    // 删除
    $scope.delete = function (id, name) {
        Common.dialog('modalDelete.html', 'ModalRoleDeleteCtrl', {id: id, name: name});
    };
    
    //编辑
    $scope.edit = function(id){
    	Discounts.resource().get({id: id}, function (data) {
              if (data.error == 0) {
                  Common.dialog('modalAdd.html', 'ModalDiscountsAddCtrl', data.data);
              }
          });
    }
}])
//添加、编辑
.controller('ModalDiscountsAddCtrl',["$scope","Common","items","Discounts", "$uibModalInstance",function($scope,Common,items,Discounts,$uibModalInstance){
	var currentId = items ? items.id : 0;
    // 账号启用状态
    $scope.status = items ? (items.status == 1 ? true : false) : true;
	$scope.name = items.name;
	$scope.discount = items.discount;
	$scope.month = items.month;
	$scope.types = [{ id: 1, name: '通用折扣' }, { id: 2, name: '新用户折扣' }, { id: 3, name: '全套折扣' }, { id: 4, name: '合同折扣' }];
	$scope.selected = items.type;
	$scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
    $scope.cancel = function () {
    	$uibModalInstance.dismiss("cancel");
    };
    
    $scope.ok = function () {
    	var data = {
            id : currentId,
            name : $scope.name,
            type : $scope.selected,
            discount : $scope.discount,
            month : $scope.month,
            status : !$scope.status ? 0 : 1
        };
    	
    	Discounts.doEdit(data, function (res) {
            if (res['error'] == 0) {
                var params = Discounts.getParams();
                Discounts.getList(params.page, params.pagesize, params.keywords);

                $uibModalInstance.dismiss("cancel");
                Common.message((currentId ? '修改' : '添加') + '成功.');
            } else {
                $scope.submitError = true;
                $scope.submit_errors = (currentId ? '修改' : '添加') + '失败,请刷新页面后重试.';
            }
        }, function (err) {
            $scope.submitError = true;

            var submit_errors = [];
            $.each(err.data, function (key, val) {
                submit_errors.push(val.join('<br />'));
            });
            $scope.submit_errors = submit_errors.join('<br />');
        });
    };
   
}])
//禁用操作
.controller('ModalRoleStatusCtrl',["$scope","$uibModalInstance","Common","items","Members",function($scope,$uibModalInstance, Common, items, Members){
	 var opName = (items.status == 0) ? '启用' : '禁用';
	 	console.log(items)
	    $scope.statusOp = opName;
	    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
	    $scope.userName = items.username;
	    
	    $scope.ok = function () {
	        var status = (items.status == 0) ? 1 : 0;
	        Members.resource().status({id: items.id}, {status: status}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Members.getParams();
	                Members.getList(params.page, params.pagesize, params.keywords);

	                msg = '已' + opName + '账号' + items.username + '.';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
	    };
	    $scope.cancel = function () {
	        $uibModalInstance.dismiss("cancel");
	    };
}])
// 删除操作
.controller("ModalRoleDeleteCtrl", ["$scope", "$uibModalInstance", "Members", "Common", "items", function ($scope, $uibModalInstance, Members, Common, items) {
    $scope.userName = items.username;

    $scope.ok = function () {
        Members.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Members.getParams();
                Members.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
;