/**
 * 会员管理
 */
app_touchmedia
.controller("AdminBrandsCtrl", ["$scope", "Common", "Config","Brands", function ($scope, Common, Config,Brands,AdminCategorysCtrl) {
	// 监控列表数据
    $scope.$watch(function () {
        return Brands.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
        
        $scope.numPerPage = Config.pageSize;
        $scope.numPerPageOpt = Config.numPerPageOptions;
        $scope.currentPage = 1;

    });
    Brands.getList(1, Config.pageSize);
    
    $scope.showDetail = function($event){
    		  	
    };
    

    
 // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Brands.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Brands.getList(currentPage, $scope.numPerPage);
    };
    $scope.finish = function(id){
    	
    	Brands.resource().get({id: id}, function (data) {
          if (data.error == 0) {
          	Common.dialog('modalProject.html', 'ModalProjectCtrl', data.data);
          }
      });
    }
    
    //查询
    $scope.search = function () {  	 	
    	Brands.getList(1, Config.pageSize, $scope.searchKeywords);
    };
    
    $scope.open = function(){
    	Common.dialog('modalAdd.html', 'ModalBrandsAddCtrl')
    };
    
    // 禁用
    $scope.status = function (id, status) {
        Common.dialog('modalStatus.html', 'ModalBrandStatusCtrl', {id: id, status: status});
    };
    
  //编辑
    $scope.edit = function(id){
    	Brands.resource().get({id: id}, function (data) {
              if (data.error == 0) {
                  Common.dialog('modalAdd.html', 'ModalBrandsAddCtrl', data.data);
              }
          });
    }
}])
//添加、编辑
.controller('ModalBrandsAddCtrl',["$scope","Common","items","Brands", "$uibModalInstance",function($scope,Common,items,Brands,$uibModalInstance){
	var currentId = items ? items.id : 0;
    // 账号启用状态
	$scope.name = items.name;
	$scope.desc = items.desc;
	$scope.type = items.type;
	$scope.account = items.account;
	$scope.channel_discount = items.channel_discount;
	$scope.status = items ? (items.status == 1 ? true : false) : true;
	$scope.types = [{ id: 1, name: 'franchise' }, { id: 2, name: 'independent' }];
	$scope.selected = items.type;
	$scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
    $scope.cancel = function () {
    	$uibModalInstance.dismiss("cancel");
    };
    
    $scope.ok = function () {
    	var data = {
            id : currentId,
            name : $scope.name,
            desc : $scope.desc,
            account:$scope.account,
            type : $scope.selected,
            status : !$scope.status ? 0 : 1
        };
    	
    	Brands.doEdit(data, function (res) {
            if (res['error'] == 0) {
                var params = Brands.getParams();
                Brands.getList(params.page, params.pagesize, params.keywords);

                $uibModalInstance.dismiss("cancel");
                Common.message((currentId ? '修改' : '添加') + '成功.');
            } else {
                $scope.submitError = true;
                $scope.submit_errors = (currentId ? '修改' : '添加') + '失败,请刷新页面后重试.';
            }
        }, function (err) {
            $scope.submitError = true;

            var submit_errors = [];
            $.each(err.data, function (key, val) {
                submit_errors.push(val.join('<br />'));
            });
            $scope.submit_errors = submit_errors.join('<br />');
        });
    };
   
}])
//禁用操作
.controller('ModalBrandStatusCtrl',["$scope","$uibModalInstance","Common","items","Brands",function($scope,$uibModalInstance, Common, items, Brands){
	 var opName = (items.status == 0) ? '启用' : '禁用';
	    $scope.statusOp = opName;
	    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
	    
	    $scope.ok = function () {
	    	
	        var status = (items.status == 0) ? 1 : 0;
	        Brands.resource().status({id: items.id}, {status: status}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Brands.getParams();
	                Brands.getList(params.page, params.pagesize, params.keywords);

	                msg = '已' + opName + '分类' + items.name + '.';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
	    };
	    $scope.cancel = function () {
	        $uibModalInstance.dismiss("cancel");
	    };
}])
// 删除操作
.controller("ModalRoleDeleteCtrl", ["$scope", "$uibModalInstance", "Members", "Common", "items", function ($scope, $uibModalInstance, Members, Common, items) {
    $scope.userName = items.username;

    $scope.ok = function () {
        Members.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Members.getParams();
                Members.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
;