/**
 * 管理员角色管理
 */
var app_touchmedia = angular.module("app.system", ["ngResource"]);
app_touchmedia
.constant('Current_page', 0)        // 当前列表页码
.controller("AdminRolesCtrl", ["$scope", "Common", "Role", "Config", function ($scope, Common, Role, Config) {
	// 监控列表数据
    $scope.$watch(function () {
        return Role.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
    });

    $scope.numPerPage = Config.pageSize;
    $scope.numPerPageOpt = Config.numPerPageOptions;
    $scope.currentPage = 1;

    Role.getList(1, Config.pageSize);

    // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
        Role.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
        Role.getList(currentPage, $scope.numPerPage);
    };

    // 新建
    $scope.open = function () {
        Common.dialog('modalAdd.html', 'ModalRoleAddCtrl');
    };

    // 编辑
    $scope.edit = function (id) {
        Role.resource().get({id: id}, function (data) {
            if (data.error == 0) {
                Common.dialog('modalAdd.html', 'ModalRoleAddCtrl', data.data);
            }
        });
    };
    
    // 权限
    $scope.permission = function (id) {
        Role.resource().get({id: id}, function (data) {
            if (data.error == 0) {
                Common.dialog('modalPermission.html', 'ModalRolePermissionCtrl', data.data);
            }
        });
    };

    // 禁用
    $scope.status = function (id, status, name) {
        Common.dialog('modalStatus.html', 'ModalRoleStatusCtrl', {id: id, status: status, name: name});
    };

    // 删除
    $scope.delete = function (id, name) {
        Common.dialog('modalDelete.html', 'ModalRoleDeleteCtrl', {id: id, name: name});
    };

    // 搜索
    $scope.search = function () {
        Role.getList(1, Config.pageSize, $scope.searchKeywords);
    };
}])
.controller("ModalRoleAddCtrl", ["$scope", "$uibModalInstance", "Role", "Common", "items", function ($scope, $uibModalInstance, Role, Common, items) {
    var currentId = items ? items.id : 0;
    // 编辑时用
    if (items) {
        $scope.roleName         = items.name;
        $scope.roleDescription  = items.description;
        $scope.roleStatus       = items.status;
    };

    // 账号启用状态
    $scope.roleStatus = items ? (items.status == 1 ? true : false) : true;
    
    $scope.ok = function () {
        var data = {
            id:          currentId,
            name:        $scope.roleName,
            description: $scope.roleDescription,
            status:     !$scope.roleStatus ? 0 : 1
        };

        Role.doEdit(data, function (res) {
            if (res['error'] == 0) {
                var params = Role.getParams();
                Role.getList(params.page, params.pagesize, params.keywords);

                $uibModalInstance.dismiss("cancel");
                Common.message((currentId ? '修改' : '添加') + '成功.');
            } else {
                $scope.submitError = true;
                $scope.submit_errors = (currentId ? '修改' : '添加') + '失败,请刷新页面后重试.';
            }
        }, function (err) {
            $scope.submitError = true;

            var submit_errors = [];
            $.each(err.data, function (key, val) {
                submit_errors.push(val.join('<br />'));
            });
            $scope.submit_errors = submit_errors.join('<br />');
        });
    };
    $scope.submitError = false;
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
    $scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
}])

//权限设置
.controller("ModalRolePermissionCtrl", ["$scope", "$uibModalInstance", "Role", "Common", "items", function ($scope, $uibModalInstance, Role, Common, items) {
	 var currentId = items ? items.id : 0;
	 //$scope.permission1 = true;
	 if (items) {
		    var my_permission = items.permission;
	        $scope.permission         = items.permission;
	        $scope.permission1 = true;
	        $scope.permission2 = true;
	        $scope.permission3 = true;
	        $scope.permission4 = true;
	        $scope.permission5 = true;
	        $scope.permission6 = true;
	        $scope.permission7 = true;
	        $scope.permission8 = true;
	        $scope.permission9 = true;
	        $scope.permission10 = true;
	        $scope.permission11 = true;
	        $scope.permission12 = true;
	        $scope.permission13 = true;
	        if(my_permission.indexOf(',1,')<0)
	        	$scope.permission1 = false;
	        if(my_permission.indexOf(',2,')<0)
	        	$scope.permission2 = false;
	        if(my_permission.indexOf(',3,')<0)
	        	$scope.permission3 = false;
	        if(my_permission.indexOf(',4,')<0)
	        	$scope.permission4 = false;
	        if(my_permission.indexOf(',5,')<0)
	        	$scope.permission5 = false;
	        if(my_permission.indexOf(',6,')<0)
	        	$scope.permission6 = false;
	        if(my_permission.indexOf(',7,')<0)
	        	$scope.permission7 = false;
	        if(my_permission.indexOf(',8,')<0)
	        	$scope.permission8 = false;
	        if(my_permission.indexOf(',9,')<0)
	        	$scope.permission9 = false;
	        if(my_permission.indexOf(',10,')<0)
	        	$scope.permission10 = false;
	        if(my_permission.indexOf(',11,')<0)
	        	$scope.permission11 = false;
	        if(my_permission.indexOf(',12,')<0)
	        	$scope.permission12 = false;
	        if(my_permission.indexOf(',13,')<0)
	        	$scope.permission13 = false;
	   };
	
	   
	
    $scope.ok = function () {
   	 var permission='';
   	 //alert($scope.permission4);
	 if($scope.permission1)
	{
		 permission = permission+1+',';
	}
	 if($scope.permission2)
		{
			 permission = permission+2+',';
		}
	 if($scope.permission3)
		{
			 permission = permission+3+',';
		}
	 if($scope.permission4)
		{
			 permission = permission+4+',';
		}
	 if($scope.permission5)
		{
			 permission = permission+5+',';
		}
	 if($scope.permission6)
		{
			 permission = permission+6+',';
		}
	 if($scope.permission7)
		{
			 permission = permission+7+',';
		}
	 if($scope.permission8)
		{
			 permission = permission+8+',';
		}
	 if($scope.permission9)
		{
			 permission = permission+9+',';
		}
	 if($scope.permission10)
		{
			 permission = permission+10+',';
		}
	 if($scope.permission11)
		{
			 permission = permission+11+',';
		}
	 if($scope.permission12)
		{
			 permission = permission+12+',';
		}
	 if($scope.permission13)
		{
			 permission = permission+13;
		}
	 
	 
    	 var data = {
            id:          currentId,
            permission:        permission,
    	 };
    	 
    	 Role.permission(data, function (res) {
             if (res['error'] == 0) {
                 var params = Role.getParams();
                 Role.getList(params.page, params.pagesize, params.keywords);

                 $uibModalInstance.dismiss("cancel");
                 Common.message((currentId ? '修改' : '添加') + '成功.');
             } else {
                 $scope.submitError = true;
                 $scope.submit_errors = (currentId ? '修改' : '添加') + '失败,请刷新页面后重试.';
             }
         }, function (err) {
             $scope.submitError = true;

             var submit_errors = [];
             $.each(err.data, function (key, val) {
                 submit_errors.push(val.join('<br />'));
             });
             $scope.submit_errors = submit_errors.join('<br />');
         });
    }
    $scope.submitError = false;
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
    $scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
}])

// 禁用或启用操作
.controller("ModalRoleStatusCtrl", ["$scope", "$uibModalInstance", "Role", "Common", "items", function ($scope, $uibModalInstance, Role, Common, items) {
    var opName = (items.status == 0) ? '启用' : '禁用';

    $scope.statusOp = opName;
    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
    $scope.roleName = items.name;

    $scope.ok = function () {
        var status = (items.status == 0) ? 1 : 0;
        Role.resource().status({id: items.id}, {status: status}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Role.getParams();
                Role.getList(params.page, params.pagesize, params.keywords);

                msg = '已' + opName + '账号' + items.name + '.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
// 删除操作
.controller("ModalRoleDeleteCtrl", ["$scope", "$uibModalInstance", "Role", "Common", "items", function ($scope, $uibModalInstance, Role, Common, items) {
  
	$scope.roleName = items.name;

    $scope.ok = function () {
        Role.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Role.getParams();
                Role.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
// 信息提示窗口
.controller("ModalMessageCtrl", ["$scope", "$uibModalInstance", "items", function ($scope, $uibModalInstance, items) {
    $scope.message = items;

    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}]);