/**
 * 模板管理
 */
app_touchmedia
.constant('Current_page', 0)        // 当前列表页码
.controller("TemplatesCtrl", ["$scope", "$location", "Template", "Config","Common", function ($scope, $location, Template, Config,Common) {
    $scope.add = function () {
        $location.path('/templates/add');
    };

    // 编辑
    $scope.edit = function (id) {
        $location.path('/templates/' + id);
    };

    $scope.$watch(function () {
        return Template.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
    });
    $scope.numPerPage = Config.pageSize;
    $scope.numPerPageOpt = Config.numPerPageOptions;
    $scope.currentPage = 1;

    Template.getList(1, Config.pageSize);
    
    // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Template.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Template.getList(currentPage, $scope.numPerPage);
    };
    
    // 复制
    $scope.copy = function (id, name) {
        Common.dialog('modalcopy.html', 'ModalTempCopyCtrl', {id: id});
    };
    
    //查询
    $scope.search = function () {
    	
    	
    	key = new Array();
    	key['name'] = $scope.name;
    	key['brand_name'] = $scope.brand_name;
    	Template.getList(1, Config.pageSize,key);
    };
    
    // 删除
    $scope.delete = function (id, name) {
    	//alert('aaa');
        Common.dialog('modalDelete.html', 'ModalTemplateDeleteCtrl', {id: id, name: name});
    };
    
    
}])

// 删除操作
.controller("ModalTempCopyCtrl", ["$scope", "$uibModalInstance", "Template", "Common", "items", function ($scope, $uibModalInstance, Template, Common, items) {
    //$scope.userName = items.username;

    $scope.ok = function () {
    	Template.resource().copy({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Template.getParams();
                Template.getList(1, params.pagesize, params.keywords);

                msg = '复制成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
// 删除操作
.controller("ModalTemplateDeleteCtrl", ["$scope", "$uibModalInstance", "Template", "Common", "items", function ($scope, $uibModalInstance, Template, Common, items) {
    //$scope.userName = items.username;

    $scope.ok = function () {
    	Template.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Template.getParams();
                Template.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
;