app_touchmedia
.controller("AdminSingboardsCtrl", ["$scope", "Common", "Config","Signboards", function ($scope, Common, Config,Signboards) {
	// 监控列表数据
    $scope.$watch(function () {
        return Signboards.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
        
        $scope.numPerPage = Config.pageSize;
        $scope.numPerPageOpt = Config.numPerPageOptions;
        $scope.currentPage = 1;

    });
    Signboards.getList(1, Config.pageSize);
    
    $scope.showDetail = function($event){
    		  	
    };
		
		// 删除
    $scope.delete = function (id, name) {
    	
        Common.dialog('modalDelete.html', 'ModalSignboardsDeleteCtrl', {id: id, name: name});
    };

    
 // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Signboards.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Signboards.getList(currentPage, $scope.numPerPage);
    };
    $scope.finish = function(id){
    	
    	Signboards.resource().get({id: id}, function (data) {
          if (data.error == 0) {
          	Common.dialog('modalSingboard.html', 'ModalSingboardCtrl', data.data);
          }
      });
    }
    
    //查询
    //查询
    $scope.search = function () {
    	key = new Array();
    	key['bn'] = $scope.bn;
    	key['ads_status'] = $scope.ads_status;
    	key['start_time'] = $scope.start_time;
    	key['end_time'] = $scope.end_time;
    	
    	Signboards.getList(1, Config.pageSize, key);
    };
    $scope.remove = function(id){
        Common.dialog('modalRemove.html', 'ModalSignboardStatusCtrl', {id: id, status: status});
    }
    //编辑
    $scope.edit = function(id){
    	window.open ('admin/signboard/edit/'+id, 'newwindow', 'height=600, width=1000, top=100px,left=200px, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no') 
    }
    
    //新建
    $scope.open = function(id){
    	
    	window.open ('admin/signboard/add', 'newwindow', 'height=600, width=1000, top=100px,left=200px, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no') 
    	//Common.dialog('modalAdd.html', 'ModalPrintsAddCtrl', {members:$scope.members})
    };
}])

//禁用操作
.controller('ModalSignboardStatusCtrl',["$scope","$uibModalInstance","Common","items","Signboards",function($scope,$uibModalInstance, Common, items, Signboards){
	 var opName = (items.status == 0) ? '启用' : '禁用';
	    $scope.statusOp = opName;
	    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
	    
	    $scope.ok = function () {
	        var status = (items.status == 0) ? 1 : 0;
	        Signboards.resource().remove({id: items.id}, {status: status}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Signboards.getParams();
	                Signboards.getList(params.page, params.pagesize, params.keywords);

	                msg = '此广告牌已移除';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
	    };
	    $scope.cancel = function () {
	        $uibModalInstance.dismiss("cancel");
	    };
}])
// 删除操作
.controller("ModalSignboardsDeleteCtrl", ["$scope", "$uibModalInstance", "Signboards", "Common", "items", function ($scope, $uibModalInstance, Signboards, Common, items) {
    $scope.userName = items.username;

    $scope.ok = function () {
    	Signboards.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Signboards.getParams();
                Signboards.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])

