app_touchmedia
.controller("AdminProjectsCtrl", ["$scope", "Common", "Config","Projects", function ($scope, Common, Config,Projects) {
	// 监控列表数据
    $scope.$watch(function () {
        return Projects.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
        
        $scope.numPerPage = Config.pageSize;
        $scope.numPerPageOpt = Config.numPerPageOptions;
        $scope.currentPage = 1;

    });
    Projects.getList(1, Config.pageSize);
    
    $scope.showDetail = function($event){
    		  	
    };
    
    $scope.appointment = function (id) {
    	window.open ('admin/appointment/'+id, 'newwindow', 'height=600, width=1000, top=0,left=0, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no') 
    	
    }
    
    $scope.print = function (id) {
    	window.open ('admin/print/'+id, 'newwindow', 'height=600, width=1000, top=0,left=0, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no') 
    	
    }
    
 // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Projects.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Projects.getList(currentPage, $scope.numPerPage);
    };
    $scope.finish = function(id){
    	
  	  Projects.resource().get({id: id}, function (data) {
          if (data.error == 0) {
          	Common.dialog('modalProject.html', 'ModalProjectCtrl', data.data);
          }
      });
    }
    
    //查询
    $scope.search = function () {
    	
    	
    	key = new Array();
    	key['project_name'] = $scope.project_name;
    	key['status'] = $scope.status;
    	key['appo_status'] = $scope.appo_status;
    	Projects.getList(1, Config.pageSize,key);
    };
}])

.controller('ModalProjectCtrl',["$scope","Common","items","Projects", "$uibModalInstance",function($scope,Common,items,Projects,$uibModalInstance){
	var currentId = items ? items.id : 0;
    // 账号启用状态
    //$scope.memberStatus = items ? (items.status == 1 ? true : false) : true;
	$scope.name = items.name;
	$scope.username = items.username;
	$scope.services = items ? (items.is_upload == 1 ? '用户上传' : '预约服务') : '';
	$scope.status = items ? (items.status == 1 ? '进行中' : '已完成') : '';
	$scope.is_appo = items ? (items.is_appo ? true : false) : false;
	$scope.is_print = items ? (items.is_print ? true : false) : false;
	$scope.appo_cost = items.appo_cost;
	$scope.print_cost = items.print_cost;
	$scope.finish_flag = items.finish_flag;
	$scope.project_cost = items ? (items.project_cost ? items.project_cost: '定价未完成') : '';
	$scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
    $scope.cancel = function () {
    	$uibModalInstance.dismiss("cancel");
    };
    
    $scope.canSubmit = function (finish_flag) {
        return finish_flag;
    };
    
    $scope.ok = function () {
    	 	//var project_id = items.project_id;
	        Projects.resource().finish({id: items.id},{cost: items.project_cost}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Projects.getParams();
	                Projects.getList(1, params.pagesize, params.keywords);

	                msg = '操作成功';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
    	};
}])