/**
 * 会员管理
 */
app_touchmedia
.controller("AdminApposCtrl", ["$scope", "Common", "Config","Appointments", function ($scope, Common, Config,Appointments,AdminApposCtrl) {
	// 监控列表数据
    $scope.$watch(function () {
        return Appointments.getDatas();
    }, function (json) {
        $scope.currentPageStores = json.data;

        if (json.currentPage > 1) {
            return false;
        }
        // 以下变量不能重复赋值,否则会出现页码跳转会一直跳转至第1页
        $scope.totalItems = json.totalFound;
        $scope.foundRecordNum = json.totalFound;
        $scope.totalRecordNum = json.total;
        
        $scope.numPerPage = Config.pageSize;
        $scope.numPerPageOpt = Config.numPerPageOptions;
        $scope.currentPage = 1;
        $scope.members = json.members;
    });
    
    Appointments.getList(1, Config.pageSize);
    
    $scope.showDetail = function($event){
    		  	
    };
    
    
 // 更改每页显示记录数
    $scope.onNumPerPageChange = function () {
    	Appointments.getList(1, $scope.numPerPage);
    };

    // 页码点击事件
    $scope.select = function (currentPage) {
    	Appointments.getList(currentPage, $scope.numPerPage);
    };
    
    
    //查询
    $scope.search = function () {
    	key = new Array();
    	key['name'] = $scope.name;
    	key['brand_name'] = $scope.username;
    	key['start_time'] = $scope.start_time;
    	key['end_time'] = $scope.end_time;
    	
    	Appointments.getList(1, Config.pageSize, key);
    };
    
    $scope.open = function(id){
    	
    	//window.open ('admin/appointments/'+id, 'newwindow', 'height=600, width=1000, top=0,left=0, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no') 
    	Common.dialog('modalAdd.html', 'ModalApposAddCtrl', {members:$scope.members})
    };
    
    // 禁用
    $scope.status = function (id, status) {
        Common.dialog('modalStatus.html', 'ModalAdStatusCtrl', {id: id, status: status});
    };
    // 删除
    $scope.delete = function (id, name) {
    	
        Common.dialog('modalDelete.html', 'ModalApposDeleteCtrl', {id: id, name: name});
    };
    
  //编辑
    $scope.edit = function(id){
    	window.open ('admin/appointment/'+id, 'newwindow', 'height=600, width=1000, top=0,left=0, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no') 
    }
}])
//添加、编辑
.controller('ModalApposAddCtrl',["$scope","Common","items","Appointments", "$uibModalInstance",function($scope,Common,items,Appointments,$uibModalInstance){
	var members = items.members;
	//alert(members);
	json_members = JSON.parse(members); 
	var currentId = items ? items.id : 0;
	//var params = Appointments.getParams();
	
	//alert(params.members);
    // 账号启用状态
	$scope.name = items.name;
	$scope.desc = items.desc;
	$scope.pos = items.pos;
	$scope.status = items ? (items.status == 1 ? true : false) : true;
	$scope.poss = json_members;
	$scope.selected = items.pos;
	$scope.canSubmit = function () {
        return $scope.form_admin_roles.$valid;
    };
    $scope.cancel = function () {
    	$uibModalInstance.dismiss("cancel");
    };
    
    $scope.ok = function () {
    	var data = {
            id : currentId,
            name : $scope.name,
            brand_name : $scope.selected,
           // status : !$scope.status ? 0 : 1
        };
    	
    	Appointments.doEdit(data, function (res) {
            if (res['error'] == 0) {
                var params = Appointments.getParams();
                Appointments.getList(params.page, params.pagesize, params.keywords);

                $uibModalInstance.dismiss("cancel");
                Common.message((currentId ? '修改' : '添加') + '成功.');
            } else {
                $scope.submitError = true;
                $scope.submit_errors = (currentId ? '修改' : '添加') + '失败,请刷新页面后重试.';
            }
        }, function (err) {
            $scope.submitError = true;

            var submit_errors = [];
            $.each(err.data, function (key, val) {
                submit_errors.push(val.join('<br />'));
            });
            $scope.submit_errors = submit_errors.join('<br />');
        });
    };
   
}])
//禁用操作
.controller('ModalAdStatusCtrl',["$scope","$uibModalInstance","Common","items","Ads",function($scope,$uibModalInstance, Common, items, Ads){
	 var opName = (items.status == 0) ? '启用' : '禁用';
	    $scope.statusOp = opName;
	    $scope.statusColor = (items.status == 0) ? '#3b8cff' : '#FF0000';
	    
	    $scope.ok = function () {
	        var status = (items.status == 0) ? 1 : 0;
	        Ads.resource().status({id: items.id}, {status: status}, function (res) {
	            var msg = '';
	            if (res['error'] == 0) {
	                var params = Ads.getParams();
	                Ads.getList(params.page, params.pagesize, params.keywords);

	                msg = '已' + opName + '此广告.';
	            } else {
	                msg = res['msg'];
	            }

	            $uibModalInstance.dismiss("cancel");
	            Common.message(msg);
	        }, function (err) {
	            $uibModalInstance.dismiss("cancel");
	            Common.message(err.data);
	        });
	    };
	    $scope.cancel = function () {
	        $uibModalInstance.dismiss("cancel");
	    };
}])
// 删除操作
.controller("ModalApposDeleteCtrl", ["$scope", "$uibModalInstance", "Appointments", "Common", "items", function ($scope, $uibModalInstance, Appointments, Common, items) {
    $scope.userName = items.username;

    $scope.ok = function () {
    	Appointments.resource().delete({id: items.id}, function (res) {
            var msg = '';
            if (res['error'] == 0) {
                var params = Appointments.getParams();
                Appointments.getList(1, params.pagesize, params.keywords);

                msg = '删除成功.';
            } else {
                msg = res['msg'];
            }

            $uibModalInstance.dismiss("cancel");
            Common.message(msg);
        }, function (err) {
            $uibModalInstance.dismiss("cancel");
            Common.message(err.data);
        });
    };
    $scope.cancel = function () {
        $uibModalInstance.dismiss("cancel");
    };
}])
;